package com.jpattern.orm.persistor.type.ext;

import java.math.BigDecimal;

import com.jpattern.orm.persistor.type.ExtendedTypeWrapper;

/**
 * 
 * @author Francesco Cina'
 *
 * Apr 1, 2012
 */
public class FloatToBigDecimalWrapper implements ExtendedTypeWrapper<Float, BigDecimal> {

	@Override
	public Class<BigDecimal> jdbcType() {
		return BigDecimal.class;
	}

	@Override
	public Class<Float> propertyType() {
		return Float.class;
	}

	@Override
	public Float wrap(final BigDecimal value) {
		if (value==null) {
			return null;
		}
		return value.floatValue();
	}

	@Override
	public BigDecimal unWrap(final Float value) {
		if (value==null) {
			return null;
		}
		return BigDecimal.valueOf(value);
	}

	@Override
	public Float clone(final Float source) {
		return source;
	}

}
