package com.jpattern.orm.persistor.type.ext;

import java.math.BigDecimal;

import com.jpattern.orm.persistor.type.ExtendedTypeWrapper;

/**
 * 
 * @author Francesco Cina'
 *
 * Apr 1, 2012
 */
public class DoubleToBigDecimalWrapper implements ExtendedTypeWrapper<Double, BigDecimal> {

	@Override
	public Class<BigDecimal> jdbcType() {
		return BigDecimal.class;
	}

	@Override
	public Class<Double> propertyType() {
		return Double.class;
	}

	@Override
	public Double wrap(final BigDecimal value) {
		if (value==null) {
			return null;
		}
		return value.doubleValue();
	}

	@Override
	public BigDecimal unWrap(final Double value) {
		if (value==null) {
			return null;
		}
		return BigDecimal.valueOf(value);
	}

	@Override
	public Double clone(final Double source) {
		return source;
	}

}
