package com.jpattern.orm.persistor.type.ext;

import com.jpattern.orm.persistor.type.ExtendedTypeWrapper;

/**
 * 
 * @author Francesco Cina'
 *
 * Apr 1, 2012
 */
public class CharacterToStringWrapper implements ExtendedTypeWrapper<Character, String> {

	@Override
	public Class<String> jdbcType() {
		return String.class;
	}

	@Override
	public Class<Character> propertyType() {
		return Character.class;
	}

	@Override
	public Character wrap(final String value) {
		if ((value==null) || value.isEmpty()) {
			return null;
		}
		return value.charAt(0);
	}

	@Override
	public String unWrap(final Character value) {
		if (value==null) {
			return null;
		}
		return String.valueOf(value);
	}

	@Override
	public Character clone(final Character source) {
		return source;
	}

}
