package com.jpattern.orm.persistor.type.ext;

import java.math.BigDecimal;

import com.jpattern.orm.persistor.type.ExtendedTypeWrapper;

/**
 * 
 * @author Francesco Cina'
 *
 * Apr 1, 2012
 */
public class ByteToBigDecimalWrapper implements ExtendedTypeWrapper<Byte, BigDecimal> {

	@Override
	public Class<BigDecimal> jdbcType() {
		return BigDecimal.class;
	}

	@Override
	public Class<Byte> propertyType() {
		return Byte.class;
	}

	@Override
	public Byte wrap(final BigDecimal value) {
		if (value==null) {
			return null;
		}
		return value.byteValue();
	}

	@Override
	public BigDecimal unWrap(final Byte value) {
		if (value==null) {
			return null;
		}
		return BigDecimal.valueOf(value);
	}

	@Override
	public Byte clone(final Byte source) {
		return source;
	}

}
