package com.jpattern.orm.persistor.type.ext;

import java.math.BigDecimal;

import com.jpattern.orm.persistor.type.ExtendedTypeWrapper;

/**
 * 
 * @author Francesco Cina'
 *
 * Apr 1, 2012
 */
public class BooleanToBigDecimalWrapper implements ExtendedTypeWrapper<Boolean, BigDecimal> {

	@Override
	public Class<BigDecimal> jdbcType() {
		return BigDecimal.class;
	}

	@Override
	public Class<Boolean> propertyType() {
		return Boolean.class;
	}

	@Override
	public Boolean wrap(final BigDecimal value) {
		if (value==null) {
			return null;
		}
		return Boolean.valueOf( !BigDecimal.ZERO.equals(value) );
	}

	@Override
	public BigDecimal unWrap(final Boolean value) {
		if (value==null) {
			return null;
		}
		if (value) {
			return BigDecimal.ONE;
		}
		return BigDecimal.ZERO;
	}

	@Override
	public Boolean clone(final Boolean source) {
		return source;
	}

}
