package com.jpattern.orm.persistor.type;

import java.util.HashMap;
import java.util.Map;

import com.jpattern.orm.exception.OrmConfigurationException;
import com.jpattern.orm.persistor.type.ext.BooleanToBigDecimalWrapper;
import com.jpattern.orm.persistor.type.ext.ByteToBigDecimalWrapper;
import com.jpattern.orm.persistor.type.ext.CharacterToStringWrapper;
import com.jpattern.orm.persistor.type.ext.DoubleToBigDecimalWrapper;
import com.jpattern.orm.persistor.type.ext.FloatToBigDecimalWrapper;
import com.jpattern.orm.persistor.type.ext.IntegerToBigDecimalWrapper;
import com.jpattern.orm.persistor.type.ext.JodaDateMidnightToTimestampWrapper;
import com.jpattern.orm.persistor.type.ext.JodaDateTimeToSqlTimestampWrapper;
import com.jpattern.orm.persistor.type.ext.JodaLocalDateTimeToSqlTimestampWrapper;
import com.jpattern.orm.persistor.type.ext.JodaLocalDateToSqlTimestampWrapper;
import com.jpattern.orm.persistor.type.ext.LongToBigDecimalWrapper;
import com.jpattern.orm.persistor.type.ext.ShortToBigDecimalWrapper;
import com.jpattern.orm.persistor.type.ext.UtilDateToSqlTimestampWrapper;
import com.jpattern.orm.persistor.type.jdbc.ArrayJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.ArrayNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.BigDecimalJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.BigDecimalNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.BlobJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.BlobNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.BooleanPrimitiveJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.BooleanPrimitiveNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.BytePrimitiveJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.BytePrimitiveNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.BytesJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.BytesNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.ClobJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.ClobNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.DateJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.DateNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.DoublePrimitiveJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.DoublePrimitiveNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.FloatPrimitiveJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.FloatPrimitiveNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.InputStreamJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.InputStreamNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.IntegerPrimitiveJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.IntegerPrimitiveNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.LongPrimitiveJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.LongPrimitiveNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.NClobJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.NClobNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.ObjectJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.ObjectNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.ReaderJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.ReaderNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.RefJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.RefNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.RowIdJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.RowIdNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.SQLXMLJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.SQLXMLNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.ShortPrimitiveJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.ShortPrimitiveNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.StringJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.StringNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.TimeJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.TimeNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.TimestampJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.TimestampNullWrapper;
import com.jpattern.orm.persistor.type.jdbc.URLJdbcIO;
import com.jpattern.orm.persistor.type.jdbc.URLNullWrapper;
import com.jpattern.orm.util.MapUtil;

/**
 * 
 * @author ufo
 *
 */
public class TypeFactory {

	private Map<Class<?>, JdbcIO<?>> jdbcIOs = new HashMap<Class<?>, JdbcIO<?>>();
	private Map<Class<?>, TypeWrapper<?,?>> typeWrappers = new HashMap<Class<?>, TypeWrapper<?,?>>();

	public TypeFactory() {
		registerJdbcType();
		registerExtendedType();
	}

	@SuppressWarnings("unchecked")
	public <DB> JdbcIO<DB> getJdbcIO(final Class<DB> clazz) {
		if (this.jdbcIOs.containsKey(clazz)) {
			return (JdbcIO<DB>) this.jdbcIOs.get(clazz);
		}
		throw new OrmConfigurationException("Not found getter in ResultSet for type [" + clazz + "]. Allowed types [" + MapUtil.keysToString(this.jdbcIOs) + "].");
	}

	@SuppressWarnings("unchecked")
	public <P, DB> TypeWrapper<P,DB> getTypeWrapper(final Class<P> clazz) {
		if (this.typeWrappers.containsKey(clazz)) {
			return (TypeWrapper<P, DB>) this.typeWrappers.get(clazz);
		}
		throw new OrmConfigurationException("Cannot manipulate properties of type [" + clazz + "]. Allowed types [" + MapUtil.keysToString(this.typeWrappers) + "]. Use another type or register a custom " + TypeWrapper.class.getName());
	}

	private void registerJdbcType() {
		this.addType(new ArrayJdbcIO(), new ArrayNullWrapper());
		this.addType(new BigDecimalJdbcIO(), new BigDecimalNullWrapper());
		this.addType(new BlobJdbcIO(), new BlobNullWrapper());
		this.addType(new BooleanPrimitiveJdbcIO(), new BooleanPrimitiveNullWrapper());
		this.addType(new BytesJdbcIO(), new BytesNullWrapper());
		this.addType(new BytePrimitiveJdbcIO(), new BytePrimitiveNullWrapper());
		this.addType(new ClobJdbcIO(), new ClobNullWrapper());
		this.addType(new DateJdbcIO(), new DateNullWrapper());
		this.addType(new DoublePrimitiveJdbcIO(), new DoublePrimitiveNullWrapper());
		this.addType(new FloatPrimitiveJdbcIO(), new FloatPrimitiveNullWrapper());
		this.addType(new InputStreamJdbcIO(), new InputStreamNullWrapper());
		this.addType(new IntegerPrimitiveJdbcIO(), new IntegerPrimitiveNullWrapper());
		this.addType(new LongPrimitiveJdbcIO(), new LongPrimitiveNullWrapper());
		this.addType(new NClobJdbcIO(), new NClobNullWrapper());
		this.addType(new ObjectJdbcIO(), new ObjectNullWrapper());
		this.addType(new ReaderJdbcIO(), new ReaderNullWrapper());
		this.addType(new RefJdbcIO(), new RefNullWrapper());
		this.addType(new RowIdJdbcIO(), new RowIdNullWrapper());
		this.addType(new ShortPrimitiveJdbcIO(), new ShortPrimitiveNullWrapper());
		this.addType(new SQLXMLJdbcIO(), new SQLXMLNullWrapper());
		this.addType(new StringJdbcIO(), new StringNullWrapper());
		this.addType(new TimeJdbcIO(), new TimeNullWrapper());
		this.addType(new TimestampJdbcIO(), new TimestampNullWrapper());
		this.addType(new URLJdbcIO(), new URLNullWrapper());
	}

	private void registerExtendedType() {
		addTypeWrapper(new BooleanToBigDecimalWrapper());
		addTypeWrapper(new ByteToBigDecimalWrapper());
		addTypeWrapper(new CharacterToStringWrapper());
		addTypeWrapper(new DoubleToBigDecimalWrapper());
		addTypeWrapper(new FloatToBigDecimalWrapper());
		addTypeWrapper(new IntegerToBigDecimalWrapper());
		addTypeWrapper(new LongToBigDecimalWrapper());
		addTypeWrapper(new ShortToBigDecimalWrapper());
		addTypeWrapper(new UtilDateToSqlTimestampWrapper());

		try {
			addTypeWrapper(new JodaDateTimeToSqlTimestampWrapper());
			addTypeWrapper(new JodaDateMidnightToTimestampWrapper());
			addTypeWrapper(new JodaLocalDateTimeToSqlTimestampWrapper());
			addTypeWrapper(new JodaLocalDateToSqlTimestampWrapper());
		} catch (final Throwable e) {}
	}

	/**
	 * This method assures that for every {@link JdbcIO} there is a correspondent {@link TypeWrapper} that
	 * convert from and to the same type.
	 * @param jdbcIO
	 * @param typeWrapper
	 */
	private <DB> void addType( final JdbcIO<DB> jdbcIO, final TypeWrapper<DB, DB> typeWrapper) {
		this.typeWrappers.put(typeWrapper.propertyType(), typeWrapper);
		this.jdbcIOs.put(jdbcIO.getDBClass(), jdbcIO);
	}

	public void addTypeWrapper( final ExtendedTypeWrapper<?, ?> typeWrapper) {
		if (!this.jdbcIOs.containsKey(typeWrapper.jdbcType())) {
			throw new OrmConfigurationException("Cannot register TypeWrapper " + typeWrapper.getClass() + ". The specified jdbc type " + typeWrapper.jdbcType() + " is not a valid type for the ResultSet and PreparedStatement getters/setters");
		}
		this.typeWrappers.put(typeWrapper.propertyType(), typeWrapper);
	}

}
