package com.jpattern.orm.persistor.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * Read from the {@link ResultSet}
 * @author ufo
 *
 * @param <DB> the type readed
 */
public interface JdbcIO<DB> {

	DB getValueFromResultSet(final ResultSet rs, final String rsColumnName) throws SQLException;

	DB getValueFromResultSet(final ResultSet rs, final int rsColumnIndex) throws SQLException;

	void setValueToPreparedStatement(final DB value, final PreparedStatement ps, final int index) throws SQLException;

	Class<DB> getDBClass();

}
