package com.jpattern.orm.persistor.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;

/**
 * This interface is used as a marker to identify Extended {@link TypeWrapper}s.
 * A wrapper for a specific type. This can be used to create custom converter from a desired type to
 * a specific {@link PreparedStatement} setter type and from a {@link ResultSet} getter type to the
 * desired type.
 * 
 * P is the class of the desired property.
 * DB is the class type of the related field in the {@link ResultSet} and {@link PreparedStatement} that will be used to perform read/write operations.
 * Valid Class type for R are:
 * 
 * byte[].class
 * Object.class
 * String.class
 * java.io.InputStream.class
 * java.io.Reader.class
 * java.math.BigDecimal.class
 * java.sql.Array.class
 * java.sql.Blob.class
 * java.sql.Clob.class
 * java.sql.Date.class
 * java.sql.NClob.class
 * java.sql.Ref.class
 * java.sql.RowId.class
 * java.sql.SQLXML.class
 * java.sql.Time.class
 * java.sql.Timestamp.class
 * java.net.URL.class
 * 
 * @author Francesco Cina'
 * @author ufo
 *
 * @param <P>
 * @param <DB>
 */
public interface ExtendedTypeWrapper<P, DB> extends TypeWrapper<P, DB> {

}
