package com.jpattern.orm.persistor.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;


/**
 * 
 * Get the value of a field using the related getter method
 * 
 * @author Francesco Cina'
 *
 * Mar 31, 2012
 */
public class SetterSetManipulator<BEAN, P> extends SetManipulator<BEAN, P> {

	private final Method setterMethod;

	public SetterSetManipulator(final Method setterMethod) {
		this.setterMethod = setterMethod;
	}

	@Override
	public void setValue(final BEAN bean, final P value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
		this.setterMethod.invoke(bean, value);
	}

}
