package com.jpattern.orm.persistor.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * 
 * Set the value of a using the related setter method
 * 
 * @author Francesco Cina'
 *
 * Mar 31, 2012
 */
public class GetterGetManipulator<BEAN, P> extends GetManipulator<BEAN, P> {

	private final Method getterMethod;

	public GetterGetManipulator(final Method getterMethod) {
		this.getterMethod = getterMethod;
	}

	@SuppressWarnings("unchecked")
	@Override
	public P getValue(final BEAN bean) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
		return (P) this.getterMethod.invoke(bean);
	}

}
