package com.jpattern.orm.persistor.reflection;

import java.lang.reflect.Field;

/**
 * 
 * Get the value of bean a using directly accessing it
 * 
 * @author Francesco Cina'
 *
 * Mar 31, 2012
 */
public class FieldGetManipulator<BEAN, P> extends GetManipulator<BEAN, P> {

	private final Field field;

	public FieldGetManipulator(final Field field) {
		this.field = field;
		field.setAccessible(true);
	}

	@SuppressWarnings("unchecked")
	@Override
	public P getValue(final BEAN bean) throws IllegalArgumentException, IllegalAccessException {
		return (P) this.field.get(bean);
	}

}
