package com.jpattern.orm.persistor.generator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

import com.jpattern.orm.exception.OrmConfigurationException;
import com.jpattern.orm.util.MapUtil;

/**
 * 
 * @author ufo
 *
 */
public class ValueCheckerFactory {

	private ValueCheckerFactory() {}

	private static Map<Class<?>, ValueChecker<?>> VALUE_CHECKERS = new HashMap<Class<?>, ValueChecker<?>>();

	static {
		addValueChecker(BigDecimal.class , new BigDecimalValueChecker());
		addValueChecker(Byte.class , new ByteValueChecker());
		addValueChecker(Byte.TYPE , new ByteValueChecker());
		addValueChecker(Integer.class , new IntegerValueChecker());
		addValueChecker(Integer.TYPE , new IntegerValueChecker());
		addValueChecker(Long.class , new LongValueChecker());
		addValueChecker(Long.TYPE , new LongValueChecker());
		addValueChecker(Short.class , new ShortValueChecker());
		addValueChecker(Short.TYPE , new ShortValueChecker());
	}

	private static <P> void addValueChecker(final Class<P> clazz , final ValueChecker<P> valueChecker) {
		VALUE_CHECKERS.put(clazz, valueChecker);
	}

	@SuppressWarnings("unchecked")
	public static <P> ValueChecker<P> getValueChecker(final Class<P> clazz) {
		if (VALUE_CHECKERS.containsKey(clazz)) {
			return (ValueChecker<P>) VALUE_CHECKERS.get(clazz);
		}
		throw new OrmConfigurationException("Cannot use type " + clazz + " for a field annotated as Generated. Valid classes are [" + MapUtil.keysToString(VALUE_CHECKERS) + "]" );
	}

}
