package com.jpattern.orm.persistor.generator;

import java.lang.reflect.InvocationTargetException;

import com.jpattern.orm.persistor.PropertyPersistor;

/**
 * 
 * @author Francesco Cina'
 *
 * Apr 1, 2012
 */
public class GeneratorManipulatorImpl<BEAN, P> extends GeneratorManipulator<BEAN> {

	private final long[] validValues;
	private final PropertyPersistor<BEAN, P, ?> fieldManipulator;
	private ValueChecker<P> valueChecker;

	public GeneratorManipulatorImpl(final PropertyPersistor<BEAN, P, ?> fieldManipulator, final ValueChecker<P> valueChecker, final long[] validValues) throws SecurityException, NoSuchMethodException {
		this.valueChecker = valueChecker;
		this.fieldManipulator = fieldManipulator;
		this.validValues = validValues;
	}

	@Override
	public  boolean useGenerator(final BEAN bean) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
		return this.valueChecker.useGenerator(this.validValues, this.fieldManipulator.getPropertyValueFromBean(bean));
	}

	@Override
	public boolean hasConditionalGenerator() {
		return this.validValues.length != 0;
	}

	@Override
	public boolean hasGenerator() {
		return true;
	}

}
