package com.jpattern.orm.persistor.generator;

import java.lang.reflect.InvocationTargetException;

import com.jpattern.orm.annotation.Generator;

/**
 * 
 * @author Francesco Cina'
 *
 * Apr 1, 2012
 */
public abstract class GeneratorManipulator<BEAN> {

	/**
	 * 
	 * Check if a generator has to be activated for a bean.
	 * This depends on the ifValueIn() method of the {@link Generator}} annotation.
	 * 
	 * @param bean
	 * @return
	 * @throws IllegalArgumentException
	 * @throws IllegalAccessException
	 * @throws InvocationTargetException
	 */
	public abstract boolean useGenerator(BEAN bean) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;

	/**
	 * This depends on the ifValueIn() method of the {@link Generator}} annotation.
	 * if a specific list of values has been specified to activate the generator the
	 * this method will return true
	 * @return
	 */
	public abstract boolean hasConditionalGenerator();

	/**
	 * Return true if a bean has an active generator associated
	 * @return
	 */
	public abstract boolean hasGenerator();
}
