package com.jpattern.orm.persistor;

import java.util.HashMap;
import java.util.Map;

import com.jpattern.orm.mapper.clazz.IClassField;
import com.jpattern.orm.mapper.clazz.IClassMap;
import com.jpattern.orm.persistor.type.JdbcIO;
import com.jpattern.orm.persistor.type.TypeFactory;
import com.jpattern.orm.persistor.type.TypeWrapper;
import com.jpattern.orm.persistor.version.NullVersionManipulator;
import com.jpattern.orm.persistor.version.VersionManipulator;
import com.jpattern.orm.persistor.version.VersionManipulatorImpl;
import com.jpattern.orm.persistor.version.VersionMath;
import com.jpattern.orm.persistor.version.VersionMathFactory;

/**
 * 
 * @author Francesco Cina'
 *
 * Mar 24, 2012
 */
public class ReflectionPersistorGenerator<BEAN> implements IPersistorGenerator<BEAN> {

	private final IClassMap<BEAN> classMap;
	private final TypeFactory typeFactory;

	public ReflectionPersistorGenerator(final IClassMap<BEAN> classMap, final TypeFactory typeFactory) {
		this.classMap = classMap;
		this.typeFactory = typeFactory;
	}

	@Override
	public IOrmPersistor<BEAN> generate() throws Exception {
		Map<String, PropertyPersistor<BEAN, ?, ?>> propertyPersistorMap = this.getPropertyPersistorMap();
		return new ReflectionOrmPersistor<BEAN>(this.classMap, propertyPersistorMap, this.getVersionManipulator(propertyPersistorMap));
	}

	private <P, DB> Map<String, PropertyPersistor<BEAN, ?, ? >> getPropertyPersistorMap() throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, NoSuchFieldException {
		Map<String, PropertyPersistor<BEAN, ?, ?>> propertyPersistors = new HashMap<String, PropertyPersistor<BEAN,?,?>>();
		for (final String columnJavaName : this.classMap.getAllColumnJavaNames()) {
			final IClassField<BEAN, P> classField = this.classMap.getClassFieldByJavaName(columnJavaName);
			VersionMath<P> versionMath = new VersionMathFactory().getMath(classField.getType(), classField.getVersionInfo().isVersionable());
			TypeWrapper<P, DB> typeWrapper = this.typeFactory.getTypeWrapper(classField.getType());
			JdbcIO<DB> jdbcIO = this.typeFactory.getJdbcIO( typeWrapper.jdbcType() );
			propertyPersistors.put(columnJavaName, new PropertyPersistor<BEAN, P, DB>(typeWrapper, jdbcIO, classField, versionMath)  );
		}
		return propertyPersistors;
	}

	private VersionManipulator<BEAN> getVersionManipulator(final Map<String, PropertyPersistor<BEAN, ?, ? >> propertyPersistorMap) {
		VersionManipulator<BEAN> versionManipulator = new NullVersionManipulator<BEAN>();

		for (final String columnJavaName : this.classMap.getAllColumnJavaNames()) {
			final IClassField<BEAN, ?> classField = this.classMap.getClassFieldByJavaName(columnJavaName);
			if (classField.getVersionInfo().isVersionable()) {
				versionManipulator = new VersionManipulatorImpl<BEAN>(propertyPersistorMap.get(classField.getFieldName()));
				break;
			}
		}

		return versionManipulator;
	}

}
