package com.jpattern.orm.persistor;

import java.sql.PreparedStatement;
import java.sql.ResultSet;

/**
 * @author Francesco Cina
 *
 * 22/mag/2011
 * 
 * The bytecode of classes that implement this interface is generated at runtime using cojen
 * 
 */
public interface IOrmPersistor<BEAN>  {

	BEAN mapRow(String rowNamePrefix, ResultSet rs, int rowNum);

	BEAN clone(BEAN entity);

	Object[] allValues(BEAN entity);
	void setAllValues(BEAN entity, PreparedStatement ps);

	Object[] allNotGeneratedValues(BEAN entity);
	void setAllNotGeneratedValues(BEAN entity, PreparedStatement ps);

	Object[] primaryKeyValues(BEAN entity);
	void setPrimaryKeyValues(BEAN entity, PreparedStatement ps);

	Object[] notPrimaryKeyValues(BEAN entity);
	void setNotPrimaryKeyValues(BEAN entity, PreparedStatement ps);

	void setNotPrimaryKeyAndThenPrimaryKeyValues(BEAN entity, PreparedStatement ps);

	Object[] primaryKeyAndVersionValues(BEAN entity);
	void setPrimaryKeyAndVersionValues(BEAN entity, PreparedStatement ps);


	boolean isVersionable();

	void increaseVersion(BEAN entity, boolean firstVersionNumber);

	/**
	 * Return whether in the save query there are automatically
	 * generated key (for example using a call to a Sequence in the
	 * insert query)
	 * @return
	 */
	boolean useKeyGenerators(BEAN entity);

	void updateGeneratedValues(ResultSet rs, BEAN entity);

	boolean hasGenerators();

	boolean hasConditionalGenerator();

}
