package com.jpattern.orm.mapper.clazz;

import com.jpattern.orm.annotation.table.TableInfo;


/**
 * 
 * @author Francesco Cina
 *
 * 22/mag/2011
 */
public interface IClassMap<BEAN>  {

	TableInfo getTableInfo();

	Class<BEAN> getMappedClass();

	<P> IClassField<BEAN, P> getClassFieldByJavaName(String javaName);

	<P> IClassField<BEAN, P> getClassFieldByDBColumnName(String dbColumnName);

	String[] getAllColumnJavaNames();

	String[] getAllNotGeneratedColumnJavaNames();

	String[] getAllGeneratedColumnJavaNames();

	String[] getAllGeneratedColumnDBNames();

	String[] getPrimaryKeyColumnJavaNames();

	String[] getNotPrimaryKeyColumnJavaNames();

	String[] getPrimaryKeyAndVersionColumnJavaNames();

}
