package com.jpattern.orm.mapper.clazz;

import com.jpattern.orm.annotation.column.ColumnInfo;
import com.jpattern.orm.annotation.generator.GeneratorInfo;
import com.jpattern.orm.annotation.version.VersionInfo;
import com.jpattern.orm.persistor.reflection.GetManipulator;
import com.jpattern.orm.persistor.reflection.SetManipulator;


/**
 * 
 * @author cinafr
 *
 * @param <P>
 */
public final class ClassField<BEAN, P> implements IClassField<BEAN, P> {

	private GetManipulator<BEAN, P> getManipulator;
	private SetManipulator<BEAN, P> setManipulator;
	private ColumnInfo columnInfo;
	private VersionInfo versionInfo;
	private GeneratorInfo generatorInfo;
	private final String fieldName;
	private final Class<P> type;
	private boolean identifier = false;

	public ClassField(final Class<P> type,  final String fieldName) {
		this.type = type;
		this.fieldName = fieldName;
	}

	@Override
	public boolean isIdentifier()
	{
		return this.identifier ;
	}

	public void setIdentifier(final boolean identifier) {
		this.identifier = identifier;
	}

	@Override
	public Class<P> getType() {
		return this.type;
	}

	@Override
	public GetManipulator<BEAN, P> getGetManipulator() {
		return this.getManipulator;
	}

	public void setGetManipulator(final GetManipulator<BEAN, P> getManipulator) {
		this.getManipulator = getManipulator;
	}

	@Override
	public SetManipulator<BEAN, P> getSetManipulator() {
		return this.setManipulator;
	}

	public void setSetManipulator(final SetManipulator<BEAN, P> setManipulator) {
		this.setManipulator = setManipulator;
	}

	@Override
	public ColumnInfo getColumnInfo() {
		return this.columnInfo;
	}

	public void setColumnInfo(final ColumnInfo columnInfo) {
		this.columnInfo = columnInfo;
	}

	@Override
	public VersionInfo getVersionInfo() {
		return this.versionInfo;
	}

	public void setVersionInfo(final VersionInfo versionInfo) {
		this.versionInfo = versionInfo;
	}

	@Override
	public GeneratorInfo getGeneratorInfo() {
		return this.generatorInfo;
	}

	public void setGeneratorInfo(final GeneratorInfo generatorInfo) {
		this.generatorInfo = generatorInfo;
	}

	@Override
	public String getFieldName() {
		return this.fieldName;
	}
}
