package com.jpattern.orm.mapper;

import java.util.Map;
import java.util.HashMap;

import com.jpattern.orm.JPO;
import com.jpattern.orm.exception.OrmException;


/**
 * 
 * @author Francesco Cina
 *
 * 22/mag/2011
 */
public class OrmClassToolMap implements IOrmClassToolMap {

	private final Map<Class<?>, IOrmClassTool<?>> classToolMap = new HashMap<Class<?>, IOrmClassTool<?>>();
	private final JPO jpOrm;

	public OrmClassToolMap(final JPO jpOrm) {
		this.jpOrm = jpOrm;
	}

	@Override
	public <T> void put(final Class<T> clazz, final IOrmClassTool<T> ormClassTool) {
		this.classToolMap.put(clazz, ormClassTool);
	}

	@Override
	public boolean containsTool(final Class<?> clazz) {
		return this.classToolMap.containsKey(clazz);
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> IOrmClassTool<T> getOrmClassTool(final Class<T> clazz) throws OrmException {
		IOrmClassTool<?> ormClazzTool = this.classToolMap.get(clazz);
		if (ormClazzTool==null) {
			this.jpOrm.register(clazz);
			ormClazzTool = this.classToolMap.get(clazz);
			//			throw new OrmException("Class " + clazz.getName() + " is not registered as an ORM entity!");
		}
		return (IOrmClassTool<T>) this.classToolMap.get(clazz);
	}

}
