package com.jpattern.orm.mapper;

import com.jpattern.orm.crud.CRUDQuery;
import com.jpattern.orm.mapper.clazz.IClassMap;
import com.jpattern.orm.persistor.IOrmPersistor;


/**
 * 
 * @author Francesco Cina
 *
 * 22/mag/2011
 */
public class OrmClassTool<BEAN> implements IOrmClassTool<BEAN> {

	private final CRUDQuery ormCRUDQuery;
	private final IClassMap<BEAN> classMapper;
	private final IOrmPersistor<BEAN> ormPersistor;

	public OrmClassTool(final IClassMap<BEAN> classMapper, final IOrmPersistor<BEAN> ormPersistor, final CRUDQuery ormCRUDQuery) {
		this.classMapper = classMapper;
		this.ormPersistor = ormPersistor;
		this.ormCRUDQuery = ormCRUDQuery;
	}

	@Override
	public IClassMap<BEAN> getClassMap() {
		return this.classMapper;
	}

	@Override
	public IOrmPersistor<BEAN> getOrmPersistor() {
		return this.ormPersistor;
	}

	@Override
	public CRUDQuery getOrmCRUDQuery() {
		return this.ormCRUDQuery;
	}

}
