package com.jpattern.orm.exception.sql;

/**
 * 
 * Exception thrown when an attempt to insert or update data
 * results in violation of an integrity constraint. Note that this
 * is not purely a relational concept; unique primary keys are
 * required by most database types.
 * 
 * @author cinafr
 *
 */
public class OrmSqlDataIntegrityViolationException extends OrmSqlException {

	private static final long serialVersionUID = 1L;

	public OrmSqlDataIntegrityViolationException(final Exception e) {
		super(e);
	}

	public OrmSqlDataIntegrityViolationException(final String message, final Exception e) {
		super(message, e);
	}

}
