package com.jpattern.orm.dialect;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

/**
 * Return the type of underlying DB
 * @author ufo
 *
 */
public class DetermineDBType {

	private final Map<String, DBType> dbProductNameMap = new HashMap<String, DBType>();

	public DetermineDBType() {

		this.dbProductNameMap.put("Derby", DBType.DERBY);

		this.dbProductNameMap.put("H2", DBType.H2);

		this.dbProductNameMap.put("HSQL", DBType.HSQLDB);

		this.dbProductNameMap.put("Oracle", DBType.ORACLE);
	}

	public DBType determineDBType(final String driverName, final String URL, final String databaseProductName) {
		for (Entry<String, DBType> entry : this.dbProductNameMap.entrySet()) {
			if ((databaseProductName!=null) && databaseProductName.contains( entry.getKey() )) {
				return entry.getValue();
			}
		}
		return DBType.UNDEFINED;
	}

}
