package com.jpattern.orm.dialect;

/**
 * 
 * @author ufo
 *
 */
public enum DBType {

	UNDEFINED(new DefaultDialect()),
	H2(new H2Dialect()),
	HSQLDB(new HSQLDB2Dialect()),
	DERBY(new DerbyDialect()),
	ORACLE(new Oracle10gDialect());

	private final Dialect dialect;

	private DBType(final Dialect dialect) {
		this.dialect = dialect;
	}

	public Dialect getDialect() {
		return this.dialect;
	}

}
