package com.jpattern.orm.crud;



/**
 * 
 * @author Francesco Cina
 *
 * 22/mag/2011
 */
public class OrmCRUDQuery implements CRUDQuery {

	private String updateQuery;
	private String deleteQuery;
	private String loadQuery;
	private String existQuery;
	private String saveQuery;
	private String baseSelectClause;
	private String baseFromClause;
	private String beanVersionQuery;
	private String saveQueryWithoutGenerators;

	@Override
	public String getLoadQuery() {
		return this.loadQuery;
	}

	@Override
	public String getSaveQuery() {
		return this.saveQuery;
	}

	@Override
	public String getDeleteQuery() {
		return this.deleteQuery;
	}

	@Override
	public String getUpdateQuery() {
		return this.updateQuery;
	}

	@Override
	public String getBaseSelectClause() {
		return getBaseSelectClause(getBaseFromClause() + ".");
	}

	@Override
	public String getBaseFromClause() {
		return this.baseFromClause;
	}

	@Override
	public String getBaseSelectClause(final String rowNamePrefix) {
		return this.baseSelectClause.replaceAll("\\" + OrmCrudConstants.ROW_NAME_PREFIX_PLACEHOLDER, rowNamePrefix);
	}

	@Override
	public String getBeanVersionQuery() {
		return this.beanVersionQuery;
	}

	@Override
	public String getSaveQueryWithoutGenerators() {
		return this.saveQueryWithoutGenerators;
	}

	/**
	 * @param updateQuery the updateQuery to set
	 */
	public void setUpdateQuery(final String updateQuery) {
		this.updateQuery = updateQuery;
	}

	/**
	 * @param deleteQuery the deleteQuery to set
	 */
	public void setDeleteQuery(final String deleteQuery) {
		this.deleteQuery = deleteQuery;
	}

	/**
	 * @param loadQuery the loadQuery to set
	 */
	public void setLoadQuery(final String loadQuery) {
		this.loadQuery = loadQuery;
	}

	/**
	 * @param saveQuery the saveQuery to set
	 */
	public void setSaveQuery(final String saveQuery) {
		this.saveQuery = saveQuery;
	}

	/**
	 * @param baseSelectClause the baseSelectClause to set
	 */
	public void setBaseSelectClause(final String baseSelectClause) {
		this.baseSelectClause = baseSelectClause;
	}

	/**
	 * @param baseFromClause the baseFromClause to set
	 */
	public void setBaseFromClause(final String baseFromClause) {
		this.baseFromClause = baseFromClause;
	}

	/**
	 * @param beanVersionQuery the beanVersionQuery to set
	 */
	public void setBeanVersionQuery(final String beanVersionQuery) {
		this.beanVersionQuery = beanVersionQuery;
	}

	/**
	 * @param saveQueryWithoutGenerators the saveQueryWithoutGenerators to set
	 */
	public void setSaveQueryWithoutGenerators(final String saveQueryWithoutGenerators) {
		this.saveQueryWithoutGenerators = saveQueryWithoutGenerators;
	}

	@Override
	public String getExistQuery() {
		return this.existQuery;
	}

	public void setExistQuery(final String existQuery) {
		this.existQuery = existQuery;
	}

}
