package com.jpattern.orm.crud;

import com.jpattern.orm.annotation.generator.GeneratorType;
import com.jpattern.orm.mapper.clazz.ClassField;

/**
 * 
 * @author Francesco Cina
 *
 * 13/giu/2011
 */
public class ColumnValueGeneratorFactory {

	private ColumnValueGeneratorFactory() {}

	public static <BEAN> AColumnValueGenerator getColumnValueGenerator(final ClassField<BEAN,? extends Object> classField, final boolean ignoreGenerator) {
		AColumnValueGenerator columnValueGenerator = new NullColumnValueGenerator(classField.getGeneratorInfo().getName());
		if (!ignoreGenerator) {
			if (classField.getGeneratorInfo().getGeneratorType().equals( GeneratorType.SEQUENCE ) ) {
				columnValueGenerator = new SequenceColumnValueGenerator(classField.getGeneratorInfo().getName());
			}
			if (classField.getGeneratorInfo().getGeneratorType().equals( GeneratorType.AUTOGENERATED ) ) {
				columnValueGenerator = new AutogeneratedColumnValueGenerator(classField.getGeneratorInfo().getName());
			}
		}
		columnValueGenerator.setActivateValues(classField.getGeneratorInfo().getIfValueIn());
		columnValueGenerator.setGeneratedColumnName(classField.getColumnInfo().getDBColumnName());
		return columnValueGenerator;
	}

}
