package com.jpattern.orm.crud;

import com.jpattern.orm.dialect.Dialect;

/**
 * 
 * @author Francesco Cina
 *
 * 05/giu/2011
 */
public abstract class AColumnValueGenerator  {

	private final String name;
	private String generatedColumnName = "";
	private long[] activateValues = {};

	public AColumnValueGenerator(final String name) {
		this.name = name;
	}

	public String getName() {
		return this.name;
	}

	public void setGeneratedColumnName(final String generatedColumnName) {
		this.generatedColumnName = generatedColumnName;
	}

	public String getGeneratedColumnName() {
		return this.generatedColumnName;
	}

	public abstract String insertQueryParameter(Dialect dialect, String currentValue);

	public abstract String insertColumn(Dialect dialect, String currentValue);

	public abstract boolean returnGeneratedKeys();

	public abstract boolean isAutoGenerated();

	public long[] getActivateValues() {
		return this.activateValues;
	}

	public void setActivateValues(final long[] activateValues) {
		this.activateValues = activateValues;
	}

}
