package com.jpattern.orm.cache;

import java.util.Arrays;

/**
 * 
 * @author ufo
 *
 */
public class CacheKey {

	private final Object[] param;
	private final String sql;

	public CacheKey(final String sql, final Object... param) {
		this.sql = sql;
		this.param = param;
	}

	public Object[] getParam() {
		return this.param;
	}

	public String getSql() {
		return this.sql;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = (prime * result) + Arrays.hashCode(this.param);
		result = (prime * result) + ((this.sql == null) ? 0 : this.sql.hashCode());
		return result;
	}

	@Override
	public boolean equals(final Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		CacheKey other = (CacheKey) obj;
		if (!Arrays.equals(this.param, other.param)) {
			return false;
		}
		if (this.sql == null) {
			if (other.sql != null) {
				return false;
			}
		} else if (!this.sql.equals(other.sql)) {
			return false;
		}
		return true;
	}


}
