package com.jpattern.orm.annotation.version;

import java.lang.reflect.Field;

import com.jpattern.orm.annotation.Version;
import com.jpattern.orm.query.LockMode;

/**
 * 
 * @author cinafr
 *
 */
public class VersionInfoFactory {

	private VersionInfoFactory() {}

	public static  VersionInfo getVersionInfo(final Field field) {
		final Version version = field.getAnnotation(Version.class);
		if (version!=null) {
			LockMode lockMode = version.lock();
			boolean versionable = true;
			return new VersionInfoImpl(lockMode, versionable);
		}
		return new VersionInfoImpl(LockMode.NO_LOCK, false);
	}

}
