package com.jpattern.orm.annotation.generator;

import java.lang.reflect.Field;

import com.jpattern.orm.annotation.Generator;

/**
 * 
 * @author cinafr
 *
 */
public class GeneratorInfoFactory {

	private GeneratorInfoFactory() {}

	public static GeneratorInfo getGeneratorInfo(final Field field) {
		Generator generator = field.getAnnotation(Generator.class);
		if (generator!=null) {
			return new GeneratorInfoImpl(generator.generatorType(), generator.name(), generator.ifValueIn(), true);
		}
		return new GeneratorInfoImpl(GeneratorType.NONE, "", new long[0], false);
	}

}
