package com.jpattern.orm.annotation.column;

import com.jpattern.orm.util.FieldDefaultNaming;

/**
 * return the column name generated from a java field name
 * 
 * @author cinafr
 *
 */
public class InferedColumnName implements ColumnInfo {

	private final String columnName;

	public InferedColumnName(final String javaFieldName) {
		this.columnName = FieldDefaultNaming.getJavanameToDBnameDefaultMapping(javaFieldName);
	}

	@Override
	public String getDBColumnName() {
		return this.columnName;
	}

}
