package com.jpattern.orm.annotation.column;

import java.lang.reflect.Field;

import com.jpattern.orm.annotation.Column;

/**
 * 
 * @author cinafr
 *
 */
public class ColumnInfoFactory {

	private ColumnInfoFactory() {}

	public static ColumnInfo getColumnInfo(final Field field) {
		Column column = field.getAnnotation(Column.class);
		if (column!=null) {
			return new AnnotationColumnInfo(column.name());
		}
		return new InferedColumnName(field.getName());
	}

}
