package com.jpattern.orm.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.jpattern.orm.query.LockMode;

/**
 * 
 * @author Francesco Cina
 *
 * 08/giu/2011
 */

@Target(value=ElementType.FIELD)
@Retention(value=RetentionPolicy.RUNTIME)
@Inherited
public @interface Version {

	/**
	 * The lock mode used for reading the last version from db.
	 * The default is LockMode.FOR_UPDATE
	 * @return
	 */
	LockMode lock() default LockMode.NO_LOCK;

}
