package com.jpattern.orm.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 
 * Define the name of the associated table
 * 
 * @author Francesco Cina
 *
 * 08/giu/2011
 */

@Target(value=ElementType.TYPE)
@Retention(value=RetentionPolicy.RUNTIME)
@Inherited
public @interface Table {

	/**
	 * If not specified the table name is generated from the Class name.
	 * @return
	 */
	String tableName() default "";

	String schemaName() default "";

}
