package com.jpattern.orm.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.jpattern.orm.annotation.generator.GeneratorType;

/**
 * 
 * Define a field that is generated automatically on save action
 * 
 * @author Francesco Cina
 *
 * 08/giu/2011
 */

@Target(value=ElementType.FIELD)
@Retention(value=RetentionPolicy.RUNTIME)
@Inherited
public @interface Generator {

	GeneratorType generatorType();

	String name();

	/**
	 * The generator is activated only if the related field's
	 * value is in the array.
	 * If the array is empty the generator is always active.
	 * @return
	 */
	long[] ifValueIn() default {};

}
