package com.jpattern.orm;

import java.util.List;

import com.jpattern.orm.exception.OrmConfigurationException;
import com.jpattern.orm.exception.OrmException;
import com.jpattern.orm.persistor.type.ExtendedTypeWrapper;
import com.jpattern.orm.session.Session;
import com.jpattern.orm.validator.Validator;

/**
 * 
 * @author Francesco Cina
 *
 * 21/mag/2011
 */
public interface JPO {

	/**
	 * Return a session from the current IJPOrm implementation
	 * @return
	 */
	Session session() throws OrmException;

	/**
	 * Destroy the current IJPOrm instance and all it's references.
	 */
	void destory();

	/**
	 * Register a new class to be managed as a bean.
	 * 
	 * @param <T>
	 * @param clazz
	 * @throws OrmConfigurationException
	 */
	<T> void register(Class<T> clazz) throws OrmConfigurationException;

	/**
	 * Register a list of classes to be managed as a beans.
	 * 
	 * @param <T>
	 * @param clazz
	 * @throws OrmConfigurationException
	 */
	void register(List<Class<?>> classes) throws OrmConfigurationException;

	/**
	 * Register a new TypeWrapper.
	 * If a TypeWrapper wraps a Class that is already mapped, the last registered TypeWrapper will be used.
	 * 
	 * @param typeWrapper
	 * @throws OrmConfigurationException
	 */
	void register(ExtendedTypeWrapper<?, ?> typeWrapper) throws OrmConfigurationException;

	/**
	 * Set the default validator to be used to validate beans before update and save actions
	 * @param validator
	 */
	void setValidator(Validator validator);
}
