/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.cache.redis.standalone;

import com.jeesuite.cache.redis.JedisProvider;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.exceptions.JedisException;

public class JedisStandaloneProvider
implements JedisProvider<Jedis, BinaryJedis> {
    protected static final Logger logger = LoggerFactory.getLogger(JedisStandaloneProvider.class);
    public static final String MODE = "standalone";
    private ThreadLocal<Jedis> context = new ThreadLocal();
    private JedisPool jedisPool;
    private String groupName;

    public JedisStandaloneProvider(String groupName, JedisPoolConfig jedisPoolConfig, String[] servers, int timeout, String password, int database, String clientName) {
        this.groupName = groupName;
        String[] addrs = servers[0].split(":");
        this.jedisPool = new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, addrs[0], Integer.parseInt(addrs[1].trim()), timeout, password, database, clientName);
    }

    @Override
    public Jedis get() throws JedisException {
        Jedis jedis = this.context.get();
        if (jedis != null) {
            return jedis;
        }
        try {
            jedis = this.jedisPool.getResource();
        }
        catch (JedisException e) {
            if (jedis != null) {
                jedis.close();
            }
            throw e;
        }
        this.context.set(jedis);
        if (logger.isTraceEnabled()) {
            logger.trace(">>get a redis conn[{}],Host:{}", (Object)jedis.toString(), (Object)jedis.getClient().getHost());
        }
        return jedis;
    }

    @Override
    public BinaryJedis getBinary() {
        return this.get();
    }

    @Override
    public void release() {
        Jedis jedis = this.context.get();
        if (jedis != null) {
            this.context.remove();
            jedis.close();
            if (logger.isTraceEnabled()) {
                logger.trace("<<release a redis conn[{}]", (Object)jedis.toString());
            }
        }
    }

    public void destroy() throws Exception {
        this.jedisPool.destroy();
    }

    @Override
    public String mode() {
        return MODE;
    }

    @Override
    public String groupName() {
        return this.groupName;
    }
}

