/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.cache.redis.shard;

import com.jeesuite.cache.redis.JedisProvider;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.BinaryShardedJedis;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;
import redis.clients.jedis.exceptions.JedisException;

public class JedisShardProvider
implements JedisProvider<ShardedJedis, BinaryShardedJedis> {
    protected static final Logger logger = LoggerFactory.getLogger(JedisShardProvider.class);
    public static final String MODE = "standard";
    private ThreadLocal<ShardedJedis> context = new ThreadLocal();
    private ShardedJedisPool jedisPool;
    private String groupName;

    public JedisShardProvider(String groupName, JedisPoolConfig jedisPoolConfig, String[] servers, int timeout) {
        this.groupName = groupName;
        List<JedisShardInfo> shards = this.buildShardInfos(servers, timeout);
        this.jedisPool = new ShardedJedisPool((GenericObjectPoolConfig)jedisPoolConfig, shards);
    }

    private List<JedisShardInfo> buildShardInfos(String[] servers, int timeout) {
        ArrayList<JedisShardInfo> infos = new ArrayList<JedisShardInfo>();
        for (String server : servers) {
            String[] addrs = server.split(":");
            JedisShardInfo info = new JedisShardInfo(addrs[0], Integer.parseInt(addrs[1].trim()), timeout);
            infos.add(info);
        }
        return infos;
    }

    @Override
    public ShardedJedis get() throws JedisException {
        ShardedJedis jedis = this.context.get();
        if (jedis != null) {
            return jedis;
        }
        try {
            jedis = this.jedisPool.getResource();
        }
        catch (JedisException e) {
            if (jedis != null) {
                jedis.close();
            }
            throw e;
        }
        this.context.set(jedis);
        if (logger.isTraceEnabled()) {
            logger.trace(">>get a redis conn[{}]", (Object)jedis.toString());
        }
        return jedis;
    }

    @Override
    public BinaryShardedJedis getBinary() {
        return this.get();
    }

    @Override
    public void release() {
        ShardedJedis jedis = this.context.get();
        if (jedis != null) {
            this.context.remove();
            jedis.close();
            if (logger.isTraceEnabled()) {
                logger.trace("<<release a redis conn[{}]", (Object)jedis.toString());
            }
        }
    }

    public void destroy() throws Exception {
        this.jedisPool.destroy();
    }

    @Override
    public String mode() {
        return MODE;
    }

    @Override
    public String groupName() {
        return this.groupName;
    }
}

