/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.cache.redis;

import com.jeesuite.cache.redis.cluster.JedisClusterProvider;
import com.jeesuite.cache.redis.sentinel.JedisSentinelProvider;
import com.jeesuite.cache.redis.standalone.JedisStandaloneProvider;
import com.jeesuite.spring.InstanceFactory;
import com.jeesuite.spring.SpringInstanceProvider;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisPoolConfig;

public class JedisProviderFactoryBean
implements ApplicationContextAware,
InitializingBean {
    protected static final Logger logger = LoggerFactory.getLogger(JedisProviderFactoryBean.class);
    public static final String DEFAULT_GROUP_NAME = "default";
    private static final String REDIS_PROVIDER_SUFFIX = "RedisProvider";
    private Pattern pattern = Pattern.compile("^.+[:]\\d{1,5}\\s*$");
    private String mode = "standalone";
    private JedisPoolConfig jedisPoolConfig;
    private String group;
    private String servers;
    private Integer timeout = 3000;
    private String password;
    private int database = 0;
    private String masterName;
    private String clientName;
    private ApplicationContext context;

    public void setGroup(String group) {
        this.group = group;
    }

    public String getGroup() {
        if (this.group == null) {
            this.group = DEFAULT_GROUP_NAME;
        }
        return this.group;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setJedisPoolConfig(JedisPoolConfig jedisPoolConfig) {
        this.jedisPoolConfig = jedisPoolConfig;
    }

    public void setServers(String servers) {
        this.servers = servers;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabase(int database) {
        this.database = database;
    }

    public void setMasterName(String masterName) {
        this.masterName = masterName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
        InstanceFactory.setInstanceProvider((SpringInstanceProvider)new SpringInstanceProvider(context));
    }

    public void afterPropertiesSet() throws Exception {
        if (this.jedisPoolConfig == null) {
            throw new Exception("jedisPoolConfig Not config ??");
        }
        if (org.apache.commons.lang3.StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.mode, this.servers})) {
            throw new Exception("type or servers is empty??");
        }
        this.registerRedisProvier();
    }

    private void registerRedisProvier() {
        String[] servers;
        String beanName = this.getGroup() + REDIS_PROVIDER_SUFFIX;
        if (this.context.containsBean(beanName)) {
            throw new RuntimeException("\u5df2\u5305\u542bgroup\u4e3a\uff3b" + this.group + "\uff3d\u7684\u7f13\u5b58\u5b9e\u4f8b");
        }
        for (String server : servers = StringUtils.tokenizeToStringArray((String)this.servers, (String)",; \t\n")) {
            if (this.pattern.matcher(server).matches()) continue;
            throw new RuntimeException("\u53c2\u6570servers\uff1a" + this.servers + "\u9519\u8bef");
        }
        Class beanClass = null;
        if ("standalone".equalsIgnoreCase(this.mode)) {
            beanClass = JedisStandaloneProvider.class;
        } else if ("cluster".equalsIgnoreCase(this.mode)) {
            beanClass = JedisClusterProvider.class;
        } else if ("sentinel".equalsIgnoreCase(this.mode)) {
            beanClass = JedisSentinelProvider.class;
            Validate.notBlank((CharSequence)this.masterName, (String)"Sentinel\u6a21\u5f0f[masterName]\u53c2\u6570 required", (Object[])new Object[0]);
        } else {
            throw new RuntimeException("\u53c2\u6570mode\uff1a" + this.mode + "\u4e0d\u652f\u6301");
        }
        DefaultListableBeanFactory acf = (DefaultListableBeanFactory)this.context.getAutowireCapableBeanFactory();
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(beanClass);
        beanDefinitionBuilder.addConstructorArgValue((Object)this.getGroup()).addConstructorArgValue((Object)this.jedisPoolConfig).addConstructorArgValue((Object)servers).addConstructorArgValue((Object)this.timeout);
        if ("standalone".equalsIgnoreCase(this.mode) || "sentinel".equalsIgnoreCase(this.mode)) {
            beanDefinitionBuilder.addConstructorArgValue((Object)org.apache.commons.lang3.StringUtils.trimToNull((String)this.password)).addConstructorArgValue((Object)this.database).addConstructorArgValue((Object)this.clientName);
        }
        if ("sentinel".equalsIgnoreCase(this.mode)) {
            beanDefinitionBuilder.addConstructorArgValue((Object)this.masterName);
        }
        acf.registerBeanDefinition(beanName, (BeanDefinition)beanDefinitionBuilder.getRawBeanDefinition());
        logger.info("register JedisProvider OK,Class:{},beanName:{}", (Object)beanClass.getSimpleName(), (Object)beanName);
    }
}

