/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.cache.redis;

import com.jeesuite.cache.redis.JedisProvider;
import com.jeesuite.spring.InstanceFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import redis.clients.jedis.BinaryJedisClusterCommands;
import redis.clients.jedis.BinaryJedisCommands;
import redis.clients.jedis.JedisCommands;
import redis.clients.jedis.MultiKeyBinaryCommands;
import redis.clients.jedis.MultiKeyBinaryJedisClusterCommands;
import redis.clients.jedis.MultiKeyCommands;
import redis.clients.jedis.MultiKeyJedisClusterCommands;

public class JedisProviderFactory {
    protected static final Logger logger = LoggerFactory.getLogger(JedisProviderFactory.class);
    private static JedisProvider<?, ?> defaultJedisProvider;
    private static Map<String, JedisProvider> jedisProviders;

    public static JedisProvider<?, ?> getJedisProvider(String groupName) {
        if (defaultJedisProvider == null) {
            JedisProviderFactory.initFactoryFromSpring();
        }
        if (StringUtils.isNotBlank((CharSequence)groupName)) {
            if (jedisProviders.containsKey(groupName)) {
                return jedisProviders.get(groupName);
            }
            logger.warn("\u672a\u627e\u5230group[{}]\u5bf9\u5e94\u7684redis\u914d\u7f6e\uff0c\u4f7f\u7528\u9ed8\u8ba4\u7f13\u5b58\u914d\u7f6e", (Object)groupName);
        }
        return defaultJedisProvider;
    }

    private static synchronized void initFactoryFromSpring() {
        if (defaultJedisProvider == null) {
            InstanceFactory.waitUtilInitialized();
            Map interfaces = InstanceFactory.getInstanceProvider().getInterfaces(JedisProvider.class);
            for (JedisProvider jp : interfaces.values()) {
                jedisProviders.put(jp.groupName(), jp);
            }
            defaultJedisProvider = jedisProviders.get("default");
            if (defaultJedisProvider == null && jedisProviders.size() == 1) {
                defaultJedisProvider = (JedisProvider)InstanceFactory.getInstance(JedisProvider.class);
            }
            Assert.notNull(defaultJedisProvider, (String)"\u65e0\u9ed8\u8ba4\u7f13\u5b58\u914d\u7f6e\uff0c\u8bf7\u6307\u5b9a\u4e00\u7ec4\u7f13\u5b58\u914d\u7f6egroup\u4e3adefault");
        }
    }

    public static JedisCommands getJedisCommands(String groupName) {
        return (JedisCommands)JedisProviderFactory.getJedisProvider(groupName).get();
    }

    public static BinaryJedisCommands getBinaryJedisCommands(String groupName) {
        return (BinaryJedisCommands)JedisProviderFactory.getJedisProvider(groupName).getBinary();
    }

    public static BinaryJedisClusterCommands getBinaryJedisClusterCommands(String groupName) {
        return (BinaryJedisClusterCommands)JedisProviderFactory.getJedisProvider(groupName).getBinary();
    }

    public static JedisCommands getJedisClusterCommands(String groupName) {
        return (JedisCommands)JedisProviderFactory.getJedisProvider(groupName).get();
    }

    public static MultiKeyCommands getMultiKeyCommands(String groupName) {
        return (MultiKeyCommands)JedisProviderFactory.getJedisProvider(groupName).get();
    }

    public static MultiKeyBinaryCommands getMultiKeyBinaryCommands(String groupName) {
        return (MultiKeyBinaryCommands)JedisProviderFactory.getJedisProvider(groupName).get();
    }

    public static MultiKeyJedisClusterCommands getMultiKeyJedisClusterCommands(String groupName) {
        return (MultiKeyJedisClusterCommands)JedisProviderFactory.getJedisProvider(groupName).get();
    }

    public static MultiKeyBinaryJedisClusterCommands getMultiKeyBinaryJedisClusterCommands(String groupName) {
        return (MultiKeyBinaryJedisClusterCommands)JedisProviderFactory.getJedisProvider(groupName).get();
    }

    public static String currentMode(String groupName) {
        return JedisProviderFactory.getJedisProvider(groupName).mode();
    }

    public static boolean isStandalone(String groupName) {
        return "standalone".equals(JedisProviderFactory.currentMode(groupName));
    }

    public static boolean isCluster(String groupName) {
        return "cluster".equals(JedisProviderFactory.currentMode(groupName));
    }

    static {
        jedisProviders = new ConcurrentHashMap<String, JedisProvider>();
    }
}

