/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.cache.local;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.jeesuite.cache.local.Level1CacheProvider;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaLevel1CacheProvider
implements Level1CacheProvider {
    private static final String _NULL = "NULL";
    private static final Logger logger = LoggerFactory.getLogger(GuavaLevel1CacheProvider.class);
    private Map<String, Cache<String, Object>> caches = new ConcurrentHashMap<String, Cache<String, Object>>();
    private int maxSize = 10000;
    private int timeToLiveSeconds = 600;

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public void setTimeToLiveSeconds(int timeToLiveSeconds) {
        this.timeToLiveSeconds = timeToLiveSeconds;
    }

    @Override
    public void start() {
    }

    @Override
    public boolean set(String cacheName, String key, Object value) {
        if (value == null) {
            return true;
        }
        Cache<String, Object> cache = this.getCacheHolder(cacheName);
        if (cache != null) {
            cache.put((Object)key, value);
        }
        return true;
    }

    @Override
    public <T> T get(String cacheName, String key) {
        try {
            Object result;
            Cache<String, Object> cache = this.getCacheHolder(cacheName);
            if (cache != null && (result = cache.get((Object)key, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return GuavaLevel1CacheProvider._NULL;
                }
            })) != null && !_NULL.equals(result)) {
                return (T)result;
            }
        }
        catch (Exception e) {
            logger.warn("get LEVEL1 cache error", (Throwable)e);
        }
        return null;
    }

    @Override
    public void remove(String cacheName, String key) {
        Cache<String, Object> cache = this.getCacheHolder(cacheName);
        if (cache != null) {
            cache.invalidateAll();
        }
    }

    private Cache<String, Object> getCacheHolder(String cacheName) {
        return this.getAndNotexistsCreateCache(cacheName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache<String, Object> getAndNotexistsCreateCache(String cacheName) {
        Cache cache = this.caches.get(cacheName);
        if (cache != null) {
            return cache;
        }
        Map<String, Cache<String, Object>> map = this.caches;
        synchronized (map) {
            cache = this.caches.get(cacheName);
            if (cache != null) {
                return cache;
            }
            cache = CacheBuilder.newBuilder().maximumSize((long)this.maxSize).expireAfterWrite((long)this.timeToLiveSeconds, TimeUnit.SECONDS).build();
            this.caches.put(cacheName, (Cache<String, Object>)cache);
        }
        return cache;
    }

    @Override
    public void remove(String cacheName) {
    }

    @Override
    public void clearAll() {
        for (Cache<String, Object> cache : this.caches.values()) {
            cache.invalidateAll();
        }
    }

    @Override
    public void close() throws IOException {
    }
}

