/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.cache.command;

import com.jeesuite.cache.command.RedisBase;
import com.jeesuite.cache.local.Level1CacheSupport;
import com.jeesuite.cache.redis.JedisProviderFactory;
import java.util.Date;

public class RedisString {
    protected static final String RESP_OK = "OK";
    protected String key;
    protected String groupName;

    public RedisString(String key) {
        this.key = key;
        if (key.contains("::")) {
            this.groupName = key.split("::")[0];
        }
    }

    public RedisString(String key, String groupName) {
        this.key = key;
        this.groupName = groupName;
    }

    public RedisString resetKey(String key) {
        this.key = key;
        return this;
    }

    public boolean set(String value) {
        return this.set(value, RedisBase.getDefaultExpireSeconds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(String value, long seconds) {
        if (value == null) {
            return false;
        }
        try {
            boolean result = JedisProviderFactory.getJedisCommands(this.groupName).set(this.key, value).equals(RESP_OK);
            if (result && seconds > 0L) {
                result = this.setExpire(seconds);
                Level1CacheSupport.getInstance().publishSyncEvent(this.key);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(String value, Date expireAt) {
        if (value == null) {
            return false;
        }
        try {
            boolean result = JedisProviderFactory.getJedisCommands(this.groupName).set(this.key, value).equals(RESP_OK);
            if (result) {
                result = this.setExpireAt(expireAt);
                Level1CacheSupport.getInstance().publishSyncEvent(this.key);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    public String get() {
        String value = (String)Level1CacheSupport.getInstance().get(this.key);
        if (value != null) {
            return value;
        }
        try {
            String string = value = JedisProviderFactory.getJedisCommands(this.groupName).get(this.key);
            return string;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
            Level1CacheSupport.getInstance().set(this.key, value);
        }
    }

    public boolean exists() {
        try {
            boolean bl = JedisProviderFactory.getJedisCommands(this.groupName).exists(this.key);
            return bl;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    public boolean remove() {
        try {
            boolean bl = JedisProviderFactory.getJedisCommands(this.groupName).del(this.key) == 1L;
            return bl;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
            Level1CacheSupport.getInstance().publishSyncEvent(this.key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setExpire(long seconds) {
        try {
            boolean bl = JedisProviderFactory.getJedisCommands(this.groupName).pexpire(this.key, seconds * 1000L) == 1L;
            return bl;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    public boolean setExpireAt(Date expireAt) {
        try {
            boolean bl = JedisProviderFactory.getJedisCommands(this.groupName).pexpireAt(this.key, expireAt.getTime()) == 1L;
            return bl;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    public Long getTtl() {
        try {
            Long l = JedisProviderFactory.getJedisCommands(this.groupName).ttl(this.key);
            return l;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    public boolean removeExpire() {
        try {
            boolean bl = JedisProviderFactory.getJedisCommands(this.groupName).persist(this.key) == 1L;
            return bl;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }
}

