/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.cache.command;

import com.jeesuite.cache.command.RedisCollection;
import com.jeesuite.cache.redis.JedisProviderFactory;
import java.util.HashSet;
import java.util.Set;

public class RedisSet
extends RedisCollection {
    public RedisSet(String key) {
        super(key);
    }

    public RedisSet(String key, long expireTime) {
        super(key, expireTime);
    }

    public RedisSet(String key, String groupName) {
        super(key, groupName);
    }

    public RedisSet(String key, String groupName, long expireTime) {
        super(key, groupName, expireTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object ... objects) {
        try {
            boolean result = false;
            byte[][] datas = this.valuesSerialize(objects);
            if (JedisProviderFactory.isCluster(this.groupName)) {
                result = JedisProviderFactory.getBinaryJedisClusterCommands(this.groupName).sadd(this.key, datas) >= 1L;
            } else {
                boolean bl = result = JedisProviderFactory.getBinaryJedisCommands(this.groupName).sadd(this.key, datas) >= 1L;
            }
            if (result) {
                this.setExpireIfNot(this.expireTime);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    public <T> Set<T> get() {
        Set datas = null;
        try {
            datas = JedisProviderFactory.isCluster(this.groupName) ? JedisProviderFactory.getBinaryJedisClusterCommands(this.groupName).smembers(this.key) : JedisProviderFactory.getBinaryJedisCommands(this.groupName).smembers(this.key);
            Set<T> set = this.toObjectSet(datas);
            return set;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object ... objects) {
        try {
            byte[][] datas = this.valuesSerialize(objects);
            if (JedisProviderFactory.isCluster(this.groupName)) {
                boolean bl = JedisProviderFactory.getBinaryJedisClusterCommands(this.groupName).srem(this.key, datas) == 1L;
                return bl;
            }
            boolean bl = JedisProviderFactory.getBinaryJedisCommands(this.groupName).srem(this.key, datas) == 1L;
            return bl;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    public long length() {
        try {
            if (JedisProviderFactory.isCluster(this.groupName)) {
                long l = JedisProviderFactory.getBinaryJedisClusterCommands(this.groupName).scard(this.key);
                return l;
            }
            long l = JedisProviderFactory.getBinaryJedisCommands(this.groupName).scard(this.key);
            return l;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    public boolean contains(Object object) {
        try {
            if (JedisProviderFactory.isCluster(this.groupName)) {
                boolean bl = JedisProviderFactory.getBinaryJedisClusterCommands(this.groupName).sismember(this.key, this.valueSerialize(object));
                return bl;
            }
            boolean bl = JedisProviderFactory.getBinaryJedisCommands(this.groupName).sismember(this.key, this.valueSerialize(object));
            return bl;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    protected <T> Set<T> toObjectSet(Set<byte[]> datas) {
        HashSet result = new HashSet();
        if (datas == null) {
            return result;
        }
        for (byte[] data : datas) {
            result.add(this.valueDerialize(data));
        }
        return result;
    }
}

