/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.cache.command;

import com.jeesuite.cache.command.RedisString;
import com.jeesuite.cache.redis.JedisProviderFactory;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import org.apache.commons.lang3.math.NumberUtils;

public class RedisNumber
extends RedisString {
    public RedisNumber(String key) {
        super(key);
    }

    public RedisNumber(String key, String groupName) {
        super(key, groupName);
    }

    public boolean set(Object value) {
        return super.set(value.toString());
    }

    public boolean set(Object value, long seconds) {
        return super.set(value.toString(), seconds);
    }

    public boolean set(Object value, Date expireAt) {
        return super.set(value.toString(), expireAt);
    }

    public Integer getInteger() {
        String value = super.get();
        return value == null ? null : Integer.valueOf(NumberUtils.toInt((String)value));
    }

    public Long getLong() {
        String value = super.get();
        return value == null ? null : Long.valueOf(NumberUtils.toLong((String)value));
    }

    public Float getFloat() {
        String value = super.get();
        return value == null ? null : Float.valueOf(NumberUtils.toFloat((String)value));
    }

    public Short getShort() {
        String value = super.get();
        return value == null ? null : Short.valueOf(NumberUtils.toShort((String)value));
    }

    public Double getDouble() {
        String value = super.get();
        return value == null ? null : Double.valueOf(NumberUtils.toDouble((String)value));
    }

    public BigDecimal getBigDecimal(int scale) {
        String value = super.get();
        return value == null ? null : new BigDecimal(value).setScale(scale, RoundingMode.HALF_UP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long increase(long integer) {
        try {
            long l = JedisProviderFactory.getJedisCommands(this.groupName).incrBy(this.key, integer);
            return l;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long reduce(long integer) {
        try {
            long l = JedisProviderFactory.getJedisCommands(this.groupName).decrBy(this.key, integer);
            return l;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }
}

