/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.cache.command;

import com.jeesuite.cache.command.RedisCollection;
import com.jeesuite.cache.redis.JedisProviderFactory;
import java.util.List;

public class RedisList
extends RedisCollection {
    public RedisList(String key) {
        super(key);
    }

    public RedisList(String key, long expireTime) {
        super(key, expireTime);
    }

    public RedisList(String key, String groupName) {
        super(key, groupName);
    }

    public RedisList(String key, String groupName, long expireTime) {
        super(key, groupName, expireTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lpush(Object ... objects) {
        try {
            boolean result = false;
            byte[][] datas = this.valuesSerialize(objects);
            if (JedisProviderFactory.isCluster(this.groupName)) {
                result = JedisProviderFactory.getBinaryJedisClusterCommands(this.groupName).lpush(this.key, datas) == 1L;
            } else {
                boolean bl = result = JedisProviderFactory.getBinaryJedisCommands(this.groupName).lpush(this.key, datas) == 1L;
            }
            if (result) {
                this.setExpireIfNot(this.expireTime);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rpush(Object ... objects) {
        try {
            byte[][] datas = this.valuesSerialize(objects);
            boolean result = false;
            if (JedisProviderFactory.isCluster(this.groupName)) {
                result = JedisProviderFactory.getBinaryJedisClusterCommands(this.groupName).rpush(this.key, datas) == 1L;
            } else {
                boolean bl = result = JedisProviderFactory.getBinaryJedisCommands(this.groupName).rpush(this.key, datas) == 1L;
            }
            if (result) {
                this.setExpireIfNot(this.expireTime);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    public <T> T lpop() {
        byte[] datas = null;
        try {
            datas = JedisProviderFactory.isCluster(this.groupName) ? JedisProviderFactory.getBinaryJedisClusterCommands(this.groupName).lpop(this.key) : JedisProviderFactory.getBinaryJedisCommands(this.groupName).lpop(this.key);
            Object t = this.valueDerialize(datas);
            return t;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    public <T> T rpop() {
        try {
            byte[] datas = null;
            datas = JedisProviderFactory.isCluster(this.groupName) ? JedisProviderFactory.getBinaryJedisClusterCommands(this.groupName).rpop(this.key) : JedisProviderFactory.getBinaryJedisCommands(this.groupName).rpop(this.key);
            Object t = this.valueDerialize(datas);
            return t;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    public <T> List<T> get() {
        return this.range(0, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> range(int start, int end) {
        try {
            List result = null;
            result = JedisProviderFactory.isCluster(this.groupName) ? JedisProviderFactory.getBinaryJedisClusterCommands(this.groupName).lrange(this.key, (long)start, (long)end) : JedisProviderFactory.getBinaryJedisCommands(this.groupName).lrange(this.key, (long)start, (long)end);
            List list = this.toObjectList(result);
            return list;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    public long length() {
        try {
            if (JedisProviderFactory.isCluster(this.groupName)) {
                long l = JedisProviderFactory.getBinaryJedisClusterCommands(this.groupName).llen(this.key);
                return l;
            }
            long l = JedisProviderFactory.getBinaryJedisCommands(this.groupName).llen(this.key);
            return l;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(long index, Object newValue) {
        try {
            boolean result = false;
            result = JedisProviderFactory.isCluster(this.groupName) ? JedisProviderFactory.getBinaryJedisClusterCommands(this.groupName).lset(this.key, index, this.valueSerialize(newValue)).equals("OK") : JedisProviderFactory.getBinaryJedisCommands(this.groupName).lset(this.key, index, this.valueSerialize(newValue)).equals("OK");
            boolean bl = result;
            return bl;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeValue(Object value) {
        try {
            boolean result = false;
            result = JedisProviderFactory.isCluster(this.groupName) ? JedisProviderFactory.getBinaryJedisClusterCommands(this.groupName).lrem(this.key, 0L, this.valueSerialize(value)) >= 1L : JedisProviderFactory.getBinaryJedisCommands(this.groupName).lrem(this.key, 0L, this.valueSerialize(value)) >= 1L;
            boolean bl = result;
            return bl;
        }
        finally {
            JedisProviderFactory.getJedisProvider(this.groupName).release();
        }
    }
}

