/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.styledxmlparser.css.util.CssUtils;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractSvgNodeRenderer;
import java.util.Map;

public class LineSvgNodeRenderer
extends AbstractSvgNodeRenderer {
    @Override
    public void doDraw(SvgDrawContext context) {
        PdfCanvas canvas = context.getCurrentCanvas();
        canvas.writeLiteral("% line\n");
        if (this.attributesAndStyles.size() > 0) {
            float x1 = 0.0f;
            float y1 = 0.0f;
            float x2 = 0.0f;
            float y2 = 0.0f;
            if (this.attributesAndStyles.containsKey("x1")) {
                x1 = this.getAttribute(this.attributesAndStyles, "x1");
            }
            if (this.attributesAndStyles.containsKey("y1")) {
                y1 = this.getAttribute(this.attributesAndStyles, "y1");
            }
            if (this.attributesAndStyles.containsKey("x2")) {
                x2 = this.getAttribute(this.attributesAndStyles, "x2");
            }
            if (this.attributesAndStyles.containsKey("y2")) {
                y2 = this.getAttribute(this.attributesAndStyles, "y2");
            }
            canvas.moveTo((double)x1, (double)y1).lineTo((double)x2, (double)y2);
        }
    }

    @Override
    protected boolean canElementFill() {
        return false;
    }

    float getAttribute(Map<String, String> attributes, String key) {
        String value = attributes.get(key);
        if (value != null && !value.isEmpty()) {
            return CssUtils.parseAbsoluteLength((String)attributes.get(key));
        }
        return 0.0f;
    }

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        LineSvgNodeRenderer copy = new LineSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        return copy;
    }
}

