/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.ext.gen;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.beetl.sql.ext.gen.CodeGen;

public class GenConfig {
    public String baseClass;
    public int spaceCount = 4;
    public boolean preferBigDecimal = true;
    public boolean preferDate = true;
    public static String template = null;
    public List<CodeGen> codeGens = new ArrayList<CodeGen>();
    private boolean display = false;
    public String space = "    ";

    public GenConfig setBaseClass(String baseClass) {
        this.baseClass = baseClass;
        return this;
    }

    public GenConfig setSpace(int count) {
        this.spaceCount = count;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(" ");
        }
        this.space = sb.toString();
        return this;
    }

    public GenConfig preferBigDecimal(boolean prefer) {
        this.preferBigDecimal = prefer;
        return this;
    }

    public GenConfig preferPrimitive(boolean primitive) {
        this.preferBigDecimal = primitive;
        return this;
    }

    public String getBaseClass() {
        return this.baseClass;
    }

    public int getSpaceCount() {
        return this.spaceCount;
    }

    public boolean isPreferBigDecimal() {
        return this.preferBigDecimal;
    }

    public boolean isPreferDate() {
        return this.preferDate;
    }

    public void setPreferDate(boolean preferDate) {
        this.preferDate = preferDate;
    }

    public void setPreferBigDecimal(boolean preferBigDecimal) {
        this.preferBigDecimal = preferBigDecimal;
    }

    public String getSpace() {
        return this.space;
    }

    public boolean isDisplay() {
        return this.display;
    }

    public GenConfig setDisplay(boolean display) {
        this.display = display;
        return this;
    }

    public static void initTemplate(String classPath) {
        template = GenConfig.getTemplate(classPath);
    }

    public static String getTemplate(String classPath) {
        try {
            InputStream ins = GenConfig.class.getResourceAsStream(classPath);
            InputStreamReader reader = new InputStreamReader(ins, "utf-8");
            char[] buffer = new char[8192];
            int len = reader.read(buffer);
            return new String(buffer, 0, len);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void initStringTemplate(String temp) {
        template = temp;
    }

    static {
        GenConfig.initTemplate("/org/beetl/sql/ext/gen/pojo.btl");
    }
}

