/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.mapping;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.beetl.sql.core.BeetlSQLException;
import org.beetl.sql.core.HumpNameConversion;
import org.beetl.sql.core.NameConversion;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.Tail;
import org.beetl.sql.core.kit.BeanKit;
import org.beetl.sql.core.kit.EnumKit;
import org.beetl.sql.core.kit.LobKit;

public class BeanProcessor {
    private static final Map<Class<?>, Object> primitiveDefaults = new HashMap();
    private final Map<String, String> columnToPropertyOverrides;
    protected static final int PROPERTY_NOT_FOUND = -1;
    private NameConversion nc = new HumpNameConversion();
    SQLManager sm;
    String dbName;

    protected BeanProcessor() {
        this(new HashMap<String, String>());
    }

    public BeanProcessor(NameConversion nc, SQLManager sm) {
        this();
        this.nc = nc;
        this.sm = sm;
        this.dbName = sm.getDbStyle().getName();
    }

    protected BeanProcessor(Map<String, String> columnToPropertyOverrides) {
        if (columnToPropertyOverrides == null) {
            throw new IllegalArgumentException("columnToPropertyOverrides map cannot be null");
        }
        this.columnToPropertyOverrides = columnToPropertyOverrides;
    }

    public <T> T toBean(ResultSet rs, Class<T> type) throws SQLException {
        PropertyDescriptor[] props = this.propertyDescriptors(type);
        ResultSetMetaData rsmd = rs.getMetaData();
        int[] columnToProperty = this.mapColumnsToProperties(type, rsmd, props);
        return this.createBean(rs, type, props, columnToProperty);
    }

    public <T> List<T> toBeanList(ResultSet rs, Class<T> type) throws SQLException {
        ArrayList<T> results = new ArrayList<T>();
        if (!rs.next()) {
            return results;
        }
        PropertyDescriptor[] props = this.propertyDescriptors(type);
        ResultSetMetaData rsmd = rs.getMetaData();
        int[] columnToProperty = this.mapColumnsToProperties(type, rsmd, props);
        do {
            results.add(this.createBean(rs, type, props, columnToProperty));
        } while (rs.next());
        return results;
    }

    public Map<String, Object> toMap(Class<?> c, ResultSet rs) throws SQLException {
        Map result = BeanKit.getMapIns(c);
        if (c == null) {
            throw new SQLException("\u4e0d\u80fd\u6620\u5c04\u6210Map:" + c);
        }
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = rsmd.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            String columnName = rsmd.getColumnLabel(i);
            if (null == columnName || 0 == columnName.length()) {
                columnName = rsmd.getColumnName(i);
            }
            if (columnName.equals("BLOB")) {
                Blob bb = rs.getBlob(i);
                byte[] b = bb.getBytes(1L, (int)bb.length());
                result.put(this.nc.getPropertyName(c, columnName), rs.getObject(i));
                continue;
            }
            result.put(this.nc.getPropertyName(c, columnName), rs.getObject(i));
        }
        return result;
    }

    private <T> T createBean(ResultSet rs, Class<T> type, PropertyDescriptor[] props, int[] columnToProperty) throws SQLException {
        T bean = this.newInstance(type);
        for (int i = 1; i < columnToProperty.length; ++i) {
            Object value;
            if (columnToProperty[i] == -1) {
                String key = rs.getMetaData().getColumnLabel(i);
                if (key.equals("beetl_rn")) continue;
                if (bean instanceof Tail) {
                    Tail bean2 = (Tail)bean;
                    value = rs.getObject(i);
                    key = this.nc.getPropertyName(type, key);
                    bean2.set(key, value);
                    continue;
                }
                Method m = BeanKit.getTailMethod(type);
                if (m == null) continue;
                value = rs.getObject(i);
                key = this.nc.getPropertyName(type, key);
                try {
                    m.invoke(bean, key, value);
                    continue;
                }
                catch (Exception ex) {
                    throw new BeetlSQLException(13, ex);
                }
            }
            PropertyDescriptor prop = props[columnToProperty[i]];
            Class<?> propType = prop.getPropertyType();
            value = null;
            if (propType != null && (value = this.processColumn(rs, i, propType)) == null && propType.isPrimitive()) {
                value = primitiveDefaults.get(propType);
            }
            this.callSetter(bean, prop, value);
        }
        return bean;
    }

    private void callSetter(Object target, PropertyDescriptor prop, Object value) throws SQLException {
        Method setter = prop.getWriteMethod();
        if (setter == null) {
            return;
        }
        Class<?>[] params = setter.getParameterTypes();
        try {
            if (value instanceof java.util.Date) {
                Class<?> targetType = params[0];
                if (Date.class == targetType) {
                    value = new Date(((java.util.Date)value).getTime());
                } else if (Time.class == targetType) {
                    value = new Time(((java.util.Date)value).getTime());
                } else if (Timestamp.class == targetType) {
                    Timestamp tsValue = (Timestamp)value;
                    int nanos = tsValue.getNanos();
                    value = new Timestamp(tsValue.getTime());
                    ((Timestamp)value).setNanos(nanos);
                }
            } else if (params[0].isEnum() && (value = EnumKit.getEnumByValue(params[0], value)) == null) {
                throw new SQLException("Cannot set ENUM " + prop.getName() + ": Convert to NULL for value" + value);
            }
            if (!this.isCompatibleType(value, params[0])) {
                throw new SQLException("Cannot set " + prop.getName() + ": incompatible types, cannot convert " + value.getClass().getName() + " to " + params[0].getName());
            }
            setter.invoke(target, value);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("Cannot set " + prop.getName() + ": " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new SQLException("Cannot set " + prop.getName() + ": " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new SQLException("Cannot set " + prop.getName() + ": " + e.getMessage());
        }
    }

    private boolean isCompatibleType(Object value, Class<?> type) {
        if (value == null || type.isInstance(value)) {
            return true;
        }
        if (type.equals(Integer.TYPE) && value instanceof Integer) {
            return true;
        }
        if (type.equals(Long.TYPE) && value instanceof Long) {
            return true;
        }
        if (type.equals(Double.TYPE) && value instanceof Double) {
            return true;
        }
        if (type.equals(Float.TYPE) && value instanceof Float) {
            return true;
        }
        if (type.equals(Short.TYPE) && value instanceof Short) {
            return true;
        }
        if (type.equals(Byte.TYPE) && value instanceof Byte) {
            return true;
        }
        if (type.equals(Character.TYPE) && value instanceof Character) {
            return true;
        }
        return type.equals(Boolean.TYPE) && value instanceof Boolean;
    }

    protected <T> T newInstance(Class<T> c) throws SQLException {
        try {
            return c.newInstance();
        }
        catch (InstantiationException e) {
            throw new BeetlSQLException(9, e);
        }
        catch (IllegalAccessException e) {
            throw new BeetlSQLException(9, e);
        }
    }

    private PropertyDescriptor[] propertyDescriptors(Class<?> c) throws SQLException {
        try {
            return BeanKit.propertyDescriptors(c);
        }
        catch (IntrospectionException e) {
            throw new SQLException("Bean introspection failed: " + e.getMessage());
        }
    }

    protected int[] mapColumnsToProperties(Class<?> c, ResultSetMetaData rsmd, PropertyDescriptor[] props) throws SQLException {
        int cols = rsmd.getColumnCount();
        int[] columnToProperty = new int[cols + 1];
        Arrays.fill(columnToProperty, -1);
        block0: for (int col = 1; col <= cols; ++col) {
            String propertyName;
            String columnName = rsmd.getColumnLabel(col);
            if (null == columnName || 0 == columnName.length()) {
                columnName = rsmd.getColumnName(col);
            }
            if ((propertyName = this.columnToPropertyOverrides.get(columnName)) == null) {
                propertyName = columnName;
            }
            for (int i = 0; i < props.length; ++i) {
                if (!props[i].getName().equalsIgnoreCase(this.nc.getPropertyName(c, propertyName))) continue;
                columnToProperty[col] = i;
                continue block0;
            }
        }
        return columnToProperty;
    }

    protected Object processColumn(ResultSet rs, int index, Class<?> propType) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        if (!propType.isPrimitive() && rs.getObject(index) == null) {
            return null;
        }
        if (propType == String.class) {
            if (this.dbName.equals("oracle")) {
                int type = meta.getColumnType(index);
                String name = meta.getColumnName(index);
                switch (type) {
                    case 2005: {
                        Reader r = rs.getClob(index).getCharacterStream();
                        return LobKit.getString(r);
                    }
                    case 2011: {
                        Reader r = rs.getNClob(index).getCharacterStream();
                        return LobKit.getString(r);
                    }
                }
                return rs.getString(index);
            }
            return rs.getString(index);
        }
        if (propType.equals(Integer.TYPE) || propType.equals(Integer.class)) {
            return rs.getInt(index);
        }
        if (propType.equals(Boolean.TYPE) || propType.equals(Boolean.class)) {
            return rs.getBoolean(index);
        }
        if (propType.equals(Long.TYPE) || propType.equals(Long.class)) {
            return rs.getLong(index);
        }
        if (propType.equals(Double.TYPE) || propType.equals(Double.class)) {
            return rs.getDouble(index);
        }
        if (propType.equals(Float.TYPE) || propType.equals(Float.class)) {
            return Float.valueOf(rs.getFloat(index));
        }
        if (propType.equals(Short.TYPE) || propType.equals(Short.class)) {
            return rs.getShort(index);
        }
        if (propType.equals(Byte.TYPE) || propType.equals(Byte.class)) {
            return rs.getByte(index);
        }
        if (propType.equals(BigDecimal.class)) {
            return rs.getBigDecimal(index);
        }
        if (propType.equals(char[].class)) {
            if (this.dbName.equals("oracle")) {
                int type = meta.getColumnType(index);
                switch (type) {
                    case 2005: {
                        Reader r = rs.getClob(index).getCharacterStream();
                        return LobKit.getString(r).toCharArray();
                    }
                    case 2011: {
                        Reader r = rs.getNClob(index).getCharacterStream();
                        return LobKit.getString(r).toCharArray();
                    }
                }
                return rs.getString(index).toCharArray();
            }
            return rs.getString(index).toCharArray();
        }
        if (propType.equals(byte[].class)) {
            return rs.getBytes(index);
        }
        if (propType.equals(Timestamp.class)) {
            return rs.getTimestamp(index);
        }
        if (propType.equals(SQLXML.class)) {
            return rs.getSQLXML(index);
        }
        return rs.getObject(index);
    }

    static {
        primitiveDefaults.put(Integer.TYPE, 0);
        primitiveDefaults.put(Short.TYPE, (short)0);
        primitiveDefaults.put(Byte.TYPE, (byte)0);
        primitiveDefaults.put(Float.TYPE, Float.valueOf(0.0f));
        primitiveDefaults.put(Double.TYPE, 0.0);
        primitiveDefaults.put(Long.TYPE, 0L);
        primitiveDefaults.put(Boolean.TYPE, Boolean.FALSE);
        primitiveDefaults.put(Character.TYPE, Character.valueOf('\u0000'));
    }
}

