/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.kit;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.core.om.MethodInvoker;
import org.beetl.core.om.ObjectUtil;
import org.beetl.sql.core.annotatoin.Tail;
import org.beetl.sql.core.kit.CaseInsensitiveHashMap;

public class BeanKit {
    private static final Map<Class, Method> tailBeans = new ConcurrentHashMap<Class, Method>();
    private static Method NULL = null;

    public static Method getTailMethod(Class type) {
        Method m = tailBeans.get(type);
        if (m != null) {
            if (m == NULL) {
                return null;
            }
            return m;
        }
        Tail an = BeanKit.getTailAnnotation(type);
        if (an == null) {
            tailBeans.put(type, NULL);
            return null;
        }
        m = BeanKit.tailMethod(type, an.set());
        if (m == null) {
            tailBeans.put(type, NULL);
            return null;
        }
        tailBeans.put(type, m);
        return m;
    }

    private static Tail getTailAnnotation(Class type) {
        if (Object.class.isAssignableFrom(type)) {
            Tail an = type.getAnnotation(Tail.class);
            if (an != null) {
                return an;
            }
            Class parent = type.getSuperclass();
            if (parent == null) {
                return null;
            }
            return BeanKit.getTailAnnotation(parent);
        }
        return null;
    }

    public static PropertyDescriptor[] propertyDescriptors(Class<?> c) throws IntrospectionException {
        BeanInfo beanInfo = null;
        beanInfo = Introspector.getBeanInfo(c);
        return beanInfo.getPropertyDescriptors();
    }

    public static List<Method> getterMethod(Class<?> c) {
        PropertyDescriptor[] ps;
        try {
            ps = BeanKit.propertyDescriptors(c);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            return null;
        }
        ArrayList<Method> list = new ArrayList<Method>();
        for (PropertyDescriptor p : ps) {
            if (p.getReadMethod() == null || p.getWriteMethod() == null) continue;
            list.add(p.getReadMethod());
        }
        return list;
    }

    public static Method tailMethod(Class type, String name) {
        try {
            Method m = type.getMethod(name, String.class, Object.class);
            return m;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static Map getMapIns(Class cls) {
        if (cls == Map.class) {
            return new CaseInsensitiveHashMap();
        }
        try {
            return (Map)cls.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List getListIns(Class list) {
        if (list == List.class) {
            return new ArrayList();
        }
        try {
            return (List)list.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getBeanProperty(Object o, String attrName) {
        try {
            MethodInvoker inv = ObjectUtil.getInvokder(o.getClass(), (String)attrName);
            return inv.get(o);
        }
        catch (Exception ex) {
            throw new RuntimeException("POJO\u5c5e\u6027\u8bbf\u95ee\u51fa\u9519:" + attrName, ex);
        }
    }

    public static void setBeanProperty(Object o, Object value, String attrName) {
        MethodInvoker inv = ObjectUtil.getInvokder(o.getClass(), (String)attrName);
        inv.set(o, value);
    }

    static {
        try {
            NULL = Object.class.getMethod("toString", new Class[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

