/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.engine;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.beetl.core.Context;
import org.beetl.core.InferContext;
import org.beetl.core.exception.BeetlException;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.FormatExpression;
import org.beetl.core.statement.FunctionExpression;
import org.beetl.core.statement.PlaceholderST;
import org.beetl.core.statement.Statement;
import org.beetl.core.statement.Type;

public class SQLPlaceholderST
extends Statement {
    public Expression expression;
    public Type type = null;
    FormatExpression format;
    public static final Set<String> textFunList = new HashSet<String>();

    public SQLPlaceholderST(PlaceholderST st) {
        super(st.token);
        this.type = st.type;
        this.expression = st.expression;
    }

    public final void execute(Context ctx) {
        try {
            Object value = this.expression.evaluate(ctx);
            if (this.expression instanceof FunctionExpression) {
                FunctionExpression fun = (FunctionExpression)this.expression;
                String funName = fun.token.text;
                if (funName.startsWith("db")) {
                    ctx.byteWriter.writeString(value != null ? value.toString() : "");
                    return;
                }
                if (textFunList.contains(funName)) {
                    ctx.byteWriter.writeString(value != null ? value.toString() : "");
                    return;
                }
            }
            ctx.byteWriter.writeString("?");
            List list = (List)ctx.getGlobal("_paras");
            list.add(value);
        }
        catch (IOException e) {
            BeetlException be = new BeetlException("CLIENT_IO_ERROR_ERROR", e.getMessage(), (Throwable)e);
            be.pushToken(this.token);
            throw be;
        }
    }

    public void infer(InferContext inferCtx) {
        this.expression.infer(inferCtx);
        this.type = this.expression.type;
    }

    static {
        textFunList.add("text");
        textFunList.add("use");
        textFunList.add("globalUse");
        textFunList.add("join");
        textFunList.add("page");
        textFunList.add("orm.single");
        textFunList.add("orm.many");
    }
}

