/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.resource;

import java.io.File;
import java.util.Map;
import org.beetl.core.GroupTemplate;
import org.beetl.core.Resource;
import org.beetl.core.ResourceLoader;
import org.beetl.core.misc.BeetlUtil;
import org.beetl.core.resource.FileResource;

public class FileResourceLoader
implements ResourceLoader {
    String root = null;
    String charset = "UTF-8";
    boolean autoCheck = false;
    String functionRoot = "funtion";
    String functionSuffix = "fn";
    GroupTemplate gt = null;

    public FileResourceLoader() {
        this.root = System.getProperty("user.dir");
    }

    public FileResourceLoader(String root) {
        this.root = root;
    }

    public FileResourceLoader(String root, String charset) {
        this.root = root;
        this.charset = charset;
    }

    @Override
    public Resource getResource(String key) {
        File file = new File(this.root, key);
        FileResource resource = new FileResource(file, key, this);
        resource.setResourceLoader(this);
        return resource;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isModified(Resource key) {
        if (this.autoCheck) {
            return key.isModified();
        }
        return false;
    }

    public boolean isAutoCheck() {
        return this.autoCheck;
    }

    public void setAutoCheck(boolean autoCheck) {
        this.autoCheck = autoCheck;
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public void init(GroupTemplate gt) {
        Map<String, String> resourceMap = gt.getConf().getResourceMap();
        if (resourceMap.get("root") != null) {
            String temp = resourceMap.get("root");
            File test = new File(this.root, temp);
            this.root = test.toString();
        }
        if (this.charset == null) {
            this.charset = resourceMap.get("charset");
        }
        this.functionSuffix = resourceMap.get("functionSuffix");
        this.autoCheck = Boolean.parseBoolean(resourceMap.get("autoCheck"));
        this.functionRoot = resourceMap.get("functionRoot");
        File root = new File(this.root, this.functionRoot);
        this.gt = gt;
        if (root.exists()) {
            String ns = "";
            String path = "/".concat(this.functionRoot).concat("/");
            BeetlUtil.autoFileFunctionRegister(gt, root, ns, path, this.functionSuffix);
        }
    }

    @Override
    public boolean exist(String key) {
        return new File(this.root, key).exists();
    }

    @Override
    public String getResourceId(Resource resource, String id) {
        if (resource == null) {
            return id;
        }
        return BeetlUtil.getRelPath(resource.getId(), id);
    }

    @Override
    public String getInfo() {
        return "FileResourceLoader,Root=" + this.root;
    }
}

